/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.jni;

import fr.asip.cps3.exemple.modele.Application;
import fr.asip.cps3.exemple.modele.jni.TraitementsSpecifiques;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.io.IOException;
import org.apache.log4j.Logger;

public class TraitementsSpecifiquesImplementation
implements TraitementsSpecifiques {
    private static Logger log = Logger.getLogger(TraitementsSpecifiquesImplementation.class);
    private static final int LOG_DEBUG = 1;
    private static final int LOG_INFO = 2;
    private static final int LOG_WARN = 3;
    private static final int LOG_ERROR = 4;
    protected static boolean estChargee = false;
    private String librairiePKCS11;
    private char[] codePorteur;
    private Application application;

    protected static synchronized void chargeLibrairieJNI(String string) {
        if (!estChargee) {
            System.loadLibrary(string);
            estChargee = true;
        }
    }

    TraitementsSpecifiquesImplementation(Application application, String string, String string2) throws IOException {
        TraitementsSpecifiquesImplementation.chargeLibrairieJNI(string);
        this.connecte(string2);
        this.application = application;
        this.librairiePKCS11 = string2;
    }

    protected synchronized native void connecte(String var1) throws IOException;

    public synchronized native void initialiseLibrairie() throws PKCS11Exception;

    public native void etatConnexionCarte() throws PKCS11Exception;

    public native void assistantAuthentification() throws PKCS11Exception;

    public native void etatSaisieCodePorteur() throws PKCS11Exception;

    public native void recyclageCodePorteur() throws PKCS11Exception;

    public native void authentificationApresRetraitCarte() throws PKCS11Exception;

    public native void authentificationApresRetraitLecteur() throws PKCS11Exception;

    public native byte[] lectureObjetDonneesApplicatives() throws PKCS11Exception;

    public native byte[] modificationObjetDonneesApplicatives() throws PKCS11Exception;

    public void log(int n, String string) {
        switch (n) {
            default: {
                log.debug((Object)string);
                break;
            }
            case 2: {
                log.info((Object)string);
                break;
            }
            case 3: {
                log.warn((Object)string);
                break;
            }
            case 4: {
                log.error((Object)string);
            }
        }
    }

    public int demandeConnexionLecteur() {
        if (this.application != null) {
            return this.application.declencheDemandeConnexionLecteur();
        }
        return 0;
    }

    public int demandeInsertionCarte() {
        if (this.application != null) {
            return this.application.declencheDemandeInsertionCarte();
        }
        return 0;
    }

    public int demandeChoixNbEssaisPossiblesAvantBlocageCodePorteur() {
        if (this.application != null) {
            return this.application.declencheDemandeChoixNbEssaisPossiblesAvantBlocageCodePorteur();
        }
        return 0;
    }

    public Object[] demandeSaisieCodePorteur(long l, long l2, char[] cArray) {
        if (this.application != null) {
            return this.application.declencheDemandeSaisieCodePorteur(l, l2, cArray != null ? new String(cArray).trim() : null);
        }
        return null;
    }

    public Object[] demandeRecyclageCodePorteur(long l, long l2, long l3, char[] cArray) {
        if (this.application != null) {
            return this.application.declencheDemandeRecyclageCodePorteur(l, l2, l3, cArray != null ? new String(cArray).trim() : null);
        }
        return null;
    }

    public int demandeActionLecteurCarte(int n, char[] cArray) {
        if (this.application != null) {
            return this.application.declencheDemandeActionLecteurCarte(n, cArray != null ? new String(cArray).trim() : null);
        }
        return 0;
    }

    public void alerteCarteRetrouvee() {
        if (this.application != null) {
            this.application.declencheAlerteCarteRetrouvee();
        }
    }

    public Object[] demandeModificationObjetDonneesApplicatives(byte[] byArray) {
        if (this.application != null) {
            return this.application.declencheDemandeModificationObjetDonneesApplicatives(byArray);
        }
        return null;
    }

    public boolean estLibrairieDefinie() {
        return this.librairiePKCS11 != null;
    }

    public boolean estInitialisee() {
        return estChargee;
    }

    public char[] getCodePorteur() {
        return this.codePorteur;
    }

    public void setCodePorteur(char[] cArray) {
        this.codePorteur = cArray;
    }
}

